//								EJEMPLO 24
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El TMR1 en el modo contador de eventos externos. Divisin de frecuencias.
//
//Mediante el generador de onda cuadrada del laboratorio se aplican pulsos por la 
//lnea RC0/T1CKI. El contador cuenta N eventos procedentes del generador y a una frecuencia
//conocida (Fg). Al llegar a 0, la lnea de salida RB0 cambia de estado. La frecuencia de salida
//en esta lnea ser: Fg/2*N

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use fast_io (C)
#use delay(clock=4000000)

int16	 temporal=8;	//Valor a cargar en el TMR1

#int_timer1				//Vector de interrupcin TMR1
tratamiento()	//Funcin de tratamiento de la interrupcin TMR1
{
	set_timer1(~temporal+1);	//Recarga el TMR1
	output_b(input_b() ^ 0x01);	//RB0 cambia de estado
}

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	output_b(0x00);		//Borra salidas
	set_tris_b(0x00);	//Puerta B salida
	set_tris_c(0xff);	//Puerta C entrada
	enable_interrupts(INT_TIMER1);	//Activa interrupcin del TMR1
	setup_timer_1(T1_EXTERNAL | T1_DIV_BY_1);	//TMR1 como contador externo de eventos
	set_timer1(~temporal+1);	//Carga TMR1 con valor del usuario (8)
	enable_interrupts(global);	//Habilita interrupciones

	while(1)
	{	
		sleep();		//Puesta en standby del PIC
	}
}	
